/*
 * Decompiled with CFR 0.152.
 */
import com.installshield.boot.BootMain;
import com.installshield.boot.CoreURLUtils;
import com.installshield.boot.ISMPClassLoader;
import com.installshield.boot.Java1SecurityManager;
import com.installshield.boot.streamhandler.ISMPURLStreamHandlerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.URLJarFile;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class run {
    public static void main(String[] stringArray) {
        run.initializeSecurityManager();
        run.registerCallBack();
        URL.setURLStreamHandlerFactory(new ISMPURLStreamHandlerFactory());
        new BootMain().boot(stringArray);
    }

    private static void initializeSecurityManager() {
        try {
            Class.forName("java.security.AccessController");
            Class<?> clazz = Class.forName("com.installshield.boot.Java2SecurityManager");
            System.setSecurityManager((SecurityManager)clazz.newInstance());
        }
        catch (Exception exception) {
            System.setSecurityManager(new Java1SecurityManager());
        }
    }

    private static void registerCallBack() {
        URLJarFile.setCallBack(new URLJarFileCallBack(){
            Map jarCache = new HashMap();

            public JarFile retrieve(URL uRL) throws IOException {
                JarFile jarFile;
                String string = uRL.getProtocol();
                String string2 = ISMPClassLoader.getURLPath(uRL);
                if (string != null && string.equals("ismpfile") && string2 != null) {
                    string2 = CoreURLUtils.decode(string2);
                }
                if ((jarFile = (JarFile)this.jarCache.get(string2)) == null) {
                    jarFile = new JarFile(string2);
                    this.jarCache.put(string2, jarFile);
                }
                return jarFile;
            }
        });
    }
}

