/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.font.NumericShaper;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.text.Bidi;
import java.util.Locale;
import javax.swing.JLabel;

public class BidiUtil {
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final int INHERIT_FROM_CONTAINER = 0;
    public static final int LEFT_TO_RIGHT = 1;
    public static final int RIGHT_TO_LEFT = 2;
    static ComponentOrientation preferredOrientation = ComponentOrientation.LEFT_TO_RIGHT;
    static boolean isArabic = false;
    static NumericShaper shaper = null;
    static float javaVersion = -1.0f;
    static final char[] mirrorTable = new char[]{'(', ')', '<', '>', '[', ']', '{', '}', '\u00ab', '\u00bb'};
    static final int nMirroredChars = mirrorTable.length;

    public static void setUILocale(Locale locale) {
        if (locale != null) {
            preferredOrientation = ComponentOrientation.getOrientation(locale);
            String string = locale.getLanguage();
            isArabic = string.equals("ar");
        }
    }

    public static ComponentOrientation getPreferredOrientation() {
        return preferredOrientation;
    }

    public static float getJavaVersion() {
        if (javaVersion == -1.0f) {
            try {
                String string = System.getProperty("java.version");
                javaVersion = Float.parseFloat(string.substring(0, 3) + string.charAt(4));
            }
            catch (Throwable throwable) {
                javaVersion = 1.5f;
            }
        }
        return javaVersion;
    }

    static boolean characterIsLTR(char c) {
        byte by = Character.getDirectionality(c);
        return by == 0 || by == 14 || by == 15;
    }

    static boolean characterIsRTL(char c) {
        byte by = Character.getDirectionality(c);
        return by == 1 || by == 2 || by == 16 || by == 17;
    }

    public static String applyTextOrientation(String string, ComponentOrientation componentOrientation) {
        if (string == null || string.length() < 1) {
            return string;
        }
        char c = string.charAt(0);
        if (componentOrientation.isLeftToRight()) {
            return BidiUtil.characterIsLTR(c) ? string : (c == '\u202b' ? '\u202a' + string.substring(1) : '\u202a' + string);
        }
        return BidiUtil.characterIsRTL(c) ? string : (c == '\u202b' ? '\u202b' + string.substring(1) : '\u202b' + string);
    }

    public static void applyLabelOrientation(JLabel jLabel, ComponentOrientation componentOrientation) {
        int n;
        if (!preferredOrientation.isLeftToRight() && jLabel.getText() != null) {
            jLabel.setText(BidiUtil.applyTextOrientation(jLabel.getText(), componentOrientation));
        }
        if ((n = jLabel.getHorizontalAlignment()) == 4) {
            jLabel.setHorizontalAlignment(11);
        } else if (n == 2) {
            jLabel.setHorizontalAlignment(10);
        }
    }

    static void strrev(char[] cArray) {
        if (cArray == null) {
            return;
        }
        int n = cArray.length;
        if (n < 2) {
            return;
        }
        for (int i = 0; i < n / 2; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[n - 1 - i];
            cArray[n - 1 - i] = c;
        }
    }

    static char mirrorCharacter(char c) {
        for (int i = 0; i < nMirroredChars; ++i) {
            if (c != mirrorTable[i]) continue;
            return mirrorTable[i ^ 1];
        }
        return c;
    }

    static void reorder(Bidi bidi, char[] cArray) {
        int n;
        int n2;
        if (bidi == null || cArray == null || cArray.length < 2) {
            return;
        }
        int n3 = bidi.getRunCount();
        if (n3 < 2 && !Bidi.requiresBidi(cArray, 0, cArray.length)) {
            return;
        }
        byte[] byArray = new byte[n3];
        Object[] objectArray = new Object[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = bidi.getRunStart(n2);
            n = bidi.getRunLimit(n2) - n4;
            objectArray[n2] = new char[n];
            System.arraycopy(cArray, n4, objectArray[n2], 0, n);
            if (1 == (bidi.getRunLevel(n2) & 1)) {
                BidiUtil.strrev((char[])objectArray[n2]);
            }
            byArray[n2] = (byte)bidi.getRunLevel(n2);
        }
        Bidi.reorderVisually(byArray, 0, objectArray, 0, n3);
        n2 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n = ((char[])objectArray[n2]).length;
            System.arraycopy(objectArray[n2], 0, cArray, n5, n);
            ++n2;
            n5 += n;
        }
    }

    public static String preorderTitleRTL(String string) {
        if (string == null || string.length() < 1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n == 1) {
            char c = cArray[0];
            cArray[0] = BidiUtil.mirrorCharacter(c);
            return c == cArray[0] ? string : new String(cArray);
        }
        Bidi bidi = new Bidi(string, 1);
        BidiUtil.reorder(bidi, cArray);
        BidiUtil.reorder(new Bidi(new String(cArray), 0), cArray);
        Bidi bidi2 = new Bidi(new String(cArray), 0);
        for (int i = 0; i < n; ++i) {
            if (((bidi.getLevelAt(BidiUtil.invertPosition(i, n)) ^ bidi2.getLevelAt(i)) & 1) != 1) continue;
            cArray[i] = BidiUtil.mirrorCharacter(cArray[i]);
        }
        return new String(cArray);
    }

    public static String shapeNumerals(String string) {
        if (!isArabic || string == null || string.length() < 1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (shaper == null) {
            shaper = NumericShaper.getContextualShaper(2, 2);
        }
        shaper.shape(cArray, 0, cArray.length);
        return new String(cArray);
    }

    public static int invertPosition(int n, int n2) {
        return n2 - n - 1;
    }

    public static void drawText(Graphics graphics, int n, int n2, String string, Component component) {
        if (graphics == null || string == null || component == null || string.length() < 1) {
            return;
        }
        Bidi bidi = new Bidi(string, component.getComponentOrientation().isLeftToRight() ? 0 : 1);
        int n3 = bidi.getRunCount();
        if (n3 > 1) {
            int n4;
            byte[] byArray = new byte[n3];
            Object[] objectArray = new String[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                objectArray[n4] = string.substring(bidi.getRunStart(n4), bidi.getRunLimit(n4));
                byArray[n4] = (byte)bidi.getRunLevel(n4);
            }
            Bidi.reorderVisually(byArray, 0, objectArray, 0, n3);
            for (n4 = 0; n4 < n3; ++n4) {
                graphics.drawString((String)objectArray[n4], n, n2);
                n += graphics.getFontMetrics().stringWidth((String)objectArray[n4]);
            }
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public static Image flipImage(Image image, Component component, int n, int n2) throws InterruptedException {
        if (null == image || null == component || n < 2 || n2 < 1) {
            return image;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 1);
        if (!mediaTracker.waitForID(1, 10000L)) {
            return image;
        }
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        if (!pixelGrabber.grabPixels() || (pixelGrabber.getStatus() & 0x20) == 0) {
            return image;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n >> 1; ++j) {
                int n3 = j + i * n;
                int n4 = BidiUtil.invertPosition(j, n) + i * n;
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
            }
        }
        return component.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }
}

