/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.BidiUtil;
import com.installshield.wizard.swing.WindowsComboBoxUIBidi;
import com.installshield.wizard.swing.WindowsProgressBarUIBidi;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsProgressBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicBorders;

public class BidiLookAndFeel {
    public static void adjustUIDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        float f = BidiUtil.getJavaVersion();
        if (uIDefaults.getBorder("ScrollPane.border") instanceof BasicBorders.FieldBorder) {
            uIDefaults.put("ScrollPane.border", new BidiFieldBorder(uIDefaults.getColor("TextField.shadow"), uIDefaults.getColor("TextField.darkShadow"), uIDefaults.getColor("TextField.highlight"), uIDefaults.getColor("TextField.light")));
        }
        if (f < 1.5f) {
            ComponentUI componentUI = uIDefaults.getUI(new JComboBox());
            if (componentUI instanceof WindowsComboBoxUI) {
                uIDefaults.put("ComboBoxUI", WindowsComboBoxUIBidi.class.getName());
            }
            if (uIDefaults.getUI(new JProgressBar()) instanceof WindowsProgressBarUI) {
                uIDefaults.put("ProgressBarUI", WindowsProgressBarUIBidi.class.getName());
            }
        }
    }

    public static void drawEtchedRectRTL(Component component, Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        graphics.translate(n2, n3);
        graphics.setColor(n == 1 ? color : color2);
        graphics.drawRect(1, 0, n4 - 2, n5 - 2);
        graphics.setColor(n == 1 ? color2 : color);
        graphics.drawLine(n4 - 3, n5 - 3, 1, 1);
        graphics.drawLine(1, 1, n4 - 3, 1);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 0);
        graphics.translate(-n2, -n3);
    }

    static class BidiFieldBorder
    extends BasicBorders.FieldBorder {
        static final long serialVersionUID = 3526482556702828304L;

        public BidiFieldBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            if (component.getComponentOrientation().isLeftToRight() || this.shadow.equals(this.highlight) && this.darkShadow.equals(this.lightHighlight)) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
                return;
            }
            Insets insets = this.getBorderInsets(component);
            if (insets.left < 1 && insets.right < 1) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
                return;
            }
            boolean bl2 = bl = component instanceof JComponent && component.isDoubleBuffered();
            if (bl) {
                ((JComponent)component).setDoubleBuffered(false);
            }
            graphics.translate(n, n2);
            Shape shape = graphics.getClip();
            Area area = new Area(new Rectangle(insets.right, 0, n3 - insets.left - insets.right, n4));
            if (shape != null) {
                area.intersect(new Area(shape));
            }
            if (!area.isEmpty()) {
                graphics.setClip(area);
                super.paintBorder(component, graphics, insets.right - insets.left, 0, n3, n4);
                graphics.setClip(shape);
            }
            BufferedImage bufferedImage = (BufferedImage)component.createImage(n3, n4);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(component.getBackground());
            graphics2D.fillRect(0, 0, n3, n4);
            super.paintBorder(component, graphics2D, 0, 0, n3, n4);
            if (insets.left > 0) {
                BidiFieldBorder.invertImageArea(bufferedImage, 0, n4, insets.left);
                graphics.drawImage(bufferedImage.getSubimage(0, 0, insets.left, n4), n3 - insets.left, 0, component);
            }
            if (insets.right > 0) {
                BidiFieldBorder.invertImageArea(bufferedImage, n3 - insets.right, n4, insets.right);
                graphics.drawImage(bufferedImage.getSubimage(n3 - insets.right, 0, insets.right, n4), 0, 0, component);
            }
            graphics.translate(-n, -n2);
            graphics2D.dispose();
            if (bl) {
                ((JComponent)component).setDoubleBuffered(true);
            }
        }

        static void invertImageArea(BufferedImage bufferedImage, int n, int n2, int n3) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3 / 2; ++j) {
                    int n4 = bufferedImage.getRGB(n + j, i);
                    int n5 = n + BidiUtil.invertPosition(j, n3);
                    bufferedImage.setRGB(n + j, i, bufferedImage.getRGB(n5, i));
                    bufferedImage.setRGB(n5, i, n4);
                }
            }
        }
    }
}

