/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

class ISInflaterInputStream
extends FilterInputStream {
    private static int DEFAULT_BUF_SIZE = 512;
    private Inflater inf;
    private byte[] buf;
    private int bufLength;
    private boolean closed = false;
    private boolean eofReached = false;

    public ISInflaterInputStream(InputStream inputStream) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.inf = new Inflater();
        this.buf = new byte[DEFAULT_BUF_SIZE];
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
    }

    private void setEOFReached(boolean bl) {
        this.eofReached = bl;
    }

    private boolean isEOF() {
        return this.eofReached;
    }

    public int read() throws IOException {
        this.ensureOpen();
        byte[] byArray = new byte[1];
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3 = -1;
            while (!this.isEOF() && (n3 = this.inf.inflate(byArray, n, n2)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    this.setEOFReached(true);
                    n3 = -1;
                    continue;
                }
                if (!this.inf.needsInput() || this.fill()) continue;
                n3 = -1;
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw new ZipException(string != null ? string : "Invalid ZLIB data format");
        }
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.isEOF()) {
            return 0;
        }
        return this.in.available();
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw new IllegalArgumentException("Negative skip length");
        }
        this.ensureOpen();
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        byte[] byArray = new byte[512];
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            if ((n2 = this.read(byArray, 0, n2)) != -1) continue;
            this.setEOFReached(true);
            break;
        }
        return n;
    }

    public void close() throws IOException {
        super.close();
        this.inf.end();
        this.in.close();
        this.in = null;
        this.closed = true;
    }

    private boolean fill() throws IOException {
        boolean bl = false;
        this.ensureOpen();
        if (this.isEOF()) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.bufLength = this.in.read(this.buf, 0, this.buf.length);
        if (this.bufLength <= 0) {
            this.setEOFReached(true);
        } else {
            this.inf.setInput(this.buf, 0, this.bufLength);
            bl = true;
        }
        return bl;
    }
}

