/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.AssemblyInf;
import com.installshield.boot.AssemblyMediaInfo;
import com.installshield.boot.CoreFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SetupCache {
    private static SetupCache setupCache = null;
    public static final String DEFAULT_ASSEMBLY_SEARCH_PATH = "assemblies";
    private static final String REL_CLASS_HOME_PATH = "classes";
    private static final String REL_ENGINE_PATH = "engine";
    private static final String ENGINE_JAR_NAME = "engine.jar";
    private static final String REL_EXTENSION_PATH = "ext";
    private static final String REL_LIBRARY_PATH = "library";
    public static final String REL_DATA_PATH = "data";
    public static final String INSTALL_DATA_FILE = "assembly.dat";
    public static final String RESOURCE_MAP_FILE = "resource.map";
    private String centralLocation;
    private String classHomePath;
    private String engineVersion;
    private String mediaHome;
    private String archive;
    private String externalHome;
    private String dataLocation;
    private String installDataPath;
    private Map dataHomes = new HashMap();
    private List searchPaths = new ArrayList();
    private Hashtable assemblyMediaInfos = new Hashtable();

    public static String[] availableInstallDataFiles(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string = CoreFileUtils.normalizeFileName(string));
        if (file.exists() && file.isDirectory()) {
            stringArray = file.list();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                String string2 = CoreFileUtils.createFileName(string, stringArray[i]);
                File file2 = new File(string2);
                if (!file2.isDirectory()) continue;
                String[] stringArray2 = file2.list();
                for (int j = 0; stringArray2 != null && j < stringArray2.length; ++j) {
                    String string3 = CoreFileUtils.createFileName(CoreFileUtils.createFileName(string2, stringArray2[j]), INSTALL_DATA_FILE);
                    File file3 = new File(string3);
                    if (!file3.exists() || !file3.isFile()) continue;
                    arrayList.add(string3);
                }
            }
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static SetupCache createTestSetupCache(String string, String string2, String string3, String string4, String string5, String string6) {
        return SetupCache.constructSetupCache(string, string2, string3, string4, string5, string6);
    }

    private static SetupCache constructSetupCache(String string, String string2, String string3, String string4, String string5, String string6) {
        SetupCache setupCache = new SetupCache();
        setupCache.initialize(string, string2, string3, string4, string5, string6);
        return setupCache;
    }

    public static SetupCache createSetupCache(String string, String string2, String string3, String string4, String string5, String string6) {
        if (setupCache == null) {
            setupCache = SetupCache.constructSetupCache(string, string2, string3, string4, string5, string6);
        }
        return setupCache;
    }

    public static SetupCache getSetupCache() {
        return setupCache;
    }

    private void initialize(String string, String string2, String string3, String string4, String string5, String string6) {
        this.centralLocation = string;
        this.dataLocation = string2;
        this.engineVersion = string3;
        this.mediaHome = string4;
        this.archive = string5;
        this.externalHome = string6;
        this.classHomePath = CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(string, REL_CLASS_HOME_PATH));
        this.installDataPath = CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(string2, REL_DATA_PATH));
    }

    public String getCentralLocationPath() {
        return this.centralLocation;
    }

    public String getClassHomePath() {
        return this.classHomePath;
    }

    public String getEngineBasePath() {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.centralLocation, REL_ENGINE_PATH));
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    private String getRelativeEngineHome() {
        return "engine/" + this.engineVersion;
    }

    public String getEngineHome() {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.centralLocation, this.getRelativeEngineHome()));
    }

    public String getRelativeEngineJar() {
        return "engine/" + this.engineVersion + "/" + ENGINE_JAR_NAME;
    }

    public String getEngineJar() {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.centralLocation, this.getRelativeEngineJar()));
    }

    public String getRelativeLibraryHome() {
        return "engine/" + this.engineVersion + "/" + REL_LIBRARY_PATH;
    }

    public String getLibraryHome() {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.centralLocation, this.getRelativeLibraryHome()));
    }

    public String getLibraryJar(String string) {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.getLibraryHome(), string));
    }

    public String getRelativeEngineExtensionHome() {
        return "engine/" + this.engineVersion + "/" + REL_EXTENSION_PATH;
    }

    public String getEngineExtensionHome() {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.centralLocation, this.getRelativeEngineExtensionHome()));
    }

    public String getEngineExtensionJar(String string) {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.getEngineExtensionHome(), string));
    }

    public String getMediaHome() {
        return this.mediaHome;
    }

    public String getExternalHome() {
        return this.externalHome;
    }

    public String getDefaultInstallDataSearchPath() {
        return CoreFileUtils.createFileName(this.externalHome, DEFAULT_ASSEMBLY_SEARCH_PATH);
    }

    public String getArchive() {
        return this.archive;
    }

    public String getDataLocationPath() {
        return this.dataLocation;
    }

    public String getInstallDataHome() {
        return this.installDataPath;
    }

    public void addInstallDataHome(String string, String string2, String string3) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("uuid cannot be null or empty string");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("version cannot be null or empty string");
        }
        if (string3 == null || string3.trim().length() == 0) {
            throw new IllegalArgumentException("data home cannot be null or empty string");
        }
        File file = new File(string3 = CoreFileUtils.normalizeFileName(string3));
        if (!file.exists()) {
            throw new IllegalArgumentException("invalid data home: \"" + string3 + "\" does not exist");
        }
        String string4 = this.createHomeKey(string, string2);
        this.dataHomes.put(string4, string3);
    }

    public void addInstallDataSearchPath(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("data search path cannot be null or empty string");
        }
        File file = new File(string = CoreFileUtils.normalizeFileName(string));
        if (!file.exists()) {
            throw new IllegalArgumentException("invalid data search path: \"" + string + "\" does not exist");
        }
        if (!this.searchPaths.contains(string)) {
            this.searchPaths.add(string);
        }
    }

    private String createHomeKey(String string, String string2) {
        return string + ";" + string2;
    }

    public String getInstallDataHome(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("uuid cannot be null or empty string");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("version cannot be null or empty string");
        }
        return this.getInstallDataHomeInternal(string, string2);
    }

    private String getInstallDataHomeInternal(String string, String string2) {
        String string3 = (String)this.dataHomes.get(this.createHomeKey(string, string2));
        if (string3 != null) {
            return CoreFileUtils.normalizeFileName(string3);
        }
        String string4 = null;
        Iterator iterator = this.searchPaths.iterator();
        while (string4 == null && iterator.hasNext()) {
            String string5 = (String)iterator.next();
            String string6 = this.constructInstallDataPath(string, string2, string5);
            File file = new File(string6);
            if (!file.exists() || !file.isDirectory()) continue;
            string4 = string6;
        }
        if (string4 == null) {
            string4 = this.constructInstallDataPath(string, string2, this.installDataPath);
        }
        return string4;
    }

    private String constructInstallDataPath(String string, String string2, String string3) {
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(string3, string + "/" + string2));
    }

    public String getInstallDataFileName(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("uuid cannot be null or empty string");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("version cannot be null or empty string");
        }
        return CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.getInstallDataHomeInternal(string, string2), INSTALL_DATA_FILE));
    }

    public String getResourceMapFileName(String string, String string2) {
        File file;
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("uuid cannot be null or empty string");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException("version cannot be null or empty string");
        }
        String string3 = CoreFileUtils.normalizeFileName(CoreFileUtils.createFileName(this.getInstallDataHomeInternal(string, string2), RESOURCE_MAP_FILE));
        if (!(string3 == null || (file = new File(string3)).exists() && file.isFile())) {
            string3 = null;
        }
        return string3;
    }

    public boolean isInstallDataAvailable(String string, String string2) {
        String string3 = this.getInstallDataFileName(string, string2);
        File file = new File(string3);
        return file.exists();
    }

    void addAssemblyMediaInfo(String string, String string2, AssemblyMediaInfo assemblyMediaInfo) {
        if (assemblyMediaInfo != null) {
            String string3 = this.createHomeKey(string, string2);
            this.assemblyMediaInfos.put(string3, assemblyMediaInfo);
        }
    }

    public Object getAssemblyMediaInfo(String string, String string2) {
        String string3 = this.createHomeKey(string, string2);
        if (this.assemblyMediaInfos.containsKey(string3)) {
            return (AssemblyMediaInfo)this.assemblyMediaInfos.get(string3);
        }
        return null;
    }

    public Object getAssemblyMediaInfo(String string) {
        try {
            AssemblyInf assemblyInf = AssemblyInf.createAssemblyInf(string);
            return this.getAssemblyMediaInfo(assemblyInf.getAssemblyUUID(), assemblyInf.getAssemblyVersion());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

