/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreTTYDisplay;
import java.util.Vector;

public class CoreTTYTable {
    private Vector rows = new Vector();
    private Vector colWeights = new Vector();
    private int indent = 0;
    private int colSpacing = 1;
    private int maxCols = 0;
    private Vector colWidths = new Vector();

    public static void main(String[] stringArray) {
        CoreTTYDisplay coreTTYDisplay = new CoreTTYDisplay();
        coreTTYDisplay.setWidth(50);
        CoreTTYTable coreTTYTable = new CoreTTYTable();
        coreTTYTable.addRow(new String[]{"Port:", "22", "Note: this is a non-standard port"});
        coreTTYTable.addRow(new String[]{"User:", "root"});
        coreTTYTable.addRow(new String[]{"Socket type:", "stream"});
        coreTTYTable.addRow(new String[]{"FTP server:", "vsftpd"});
        coreTTYTable.addRow(new String[]{"Disable:", "no"});
        coreTTYTable.setColWeight(0, 0);
        coreTTYTable.setColWeight(1, 0);
        coreTTYTable.setColWeight(2, 1);
        coreTTYTable.setColSpacing(3);
        coreTTYTable.setIndent(3);
        coreTTYDisplay.printLine("Please review the settings below before continuing:");
        coreTTYDisplay.printLine();
        coreTTYDisplay.printTable(coreTTYTable);
    }

    public void addRow(String[] stringArray) {
        this.rows.addElement(stringArray);
        this.refreshMetaData(stringArray);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColCount() {
        return this.maxCols;
    }

    public String[] getRow(int n) {
        return (String[])this.rows.elementAt(n);
    }

    public int getColWidth(int n) {
        return (Integer)this.colWidths.elementAt(n);
    }

    public String getValue(int n, int n2) {
        String[] stringArray = this.getRow(n);
        return n2 >= 0 && n2 < stringArray.length ? stringArray[n2] : "";
    }

    public void deleteRow(int n) {
        this.rows.removeElementAt(n);
        this.refreshMetaData();
    }

    public void clear() {
        this.rows.removeAllElements();
        this.refreshMetaData();
    }

    private void refreshMetaData() {
        this.maxCols = 0;
        this.colWidths.removeAllElements();
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.refreshMetaData(this.getRow(i));
        }
    }

    private void refreshMetaData(String[] stringArray) {
        this.maxCols = Math.max(this.maxCols, stringArray.length);
        if (this.maxCols > this.colWidths.size()) {
            this.colWidths.setSize(this.maxCols);
        }
        for (int i = 0; i < this.colWidths.size(); ++i) {
            int n = i < stringArray.length ? stringArray[i].length() : 0;
            Integer n2 = (Integer)this.colWidths.elementAt(i);
            if (n2 != null && n <= n2) {
                n = n2;
            }
            this.colWidths.setElementAt(new Integer(n), i);
        }
    }

    public void setColWeight(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            if (this.colWeights.size() < n + 1) {
                this.colWeights.setSize(n + 1);
            }
            this.colWeights.setElementAt(new Integer(n2), n);
        }
    }

    public int getColWeight(int n) {
        if (n >= 0 && n < this.colWeights.size()) {
            Integer n2 = (Integer)this.colWeights.elementAt(n);
            return n2 != null ? n2 : 0;
        }
        return 0;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setColSpacing(int n) {
        this.colSpacing = n;
    }

    public int getColSpacing() {
        return this.colSpacing;
    }
}

