/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import java.util.Vector;

public class CoreTTYPrompt {
    private String text;
    private String description = "";
    private String defaultValue = null;
    private String help = "";
    private int indent = 0;
    private String[] options = new String[0];
    private Vector optionDesc = new Vector();
    private boolean promptForOptionIndex = false;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private boolean ignoreCase = false;

    public CoreTTYPrompt() {
        this("");
    }

    public CoreTTYPrompt(String string) {
        this.setText(string);
    }

    public CoreTTYPrompt(String string, String string2) {
        this(string);
        this.setDefaultValue(string2);
    }

    public CoreTTYPrompt(String string, String string2, String string3) {
        this(string, string2);
        this.setHelpText(string3);
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.length() > 0;
    }

    public void setDefaultValue(int n) {
        this.defaultValue = n != Integer.MIN_VALUE ? "" + n : null;
    }

    public int getDefaultValueAsInt() {
        try {
            return Integer.parseInt(this.defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public void setHelpText(String string) {
        this.help = string;
    }

    public String getHelpText() {
        return this.help;
    }

    public boolean hasHelpText() {
        return this.help != null && this.help.length() > 0;
    }

    public void setIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("indent cannot be negative");
        }
        this.indent = n;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setOptions(String[] stringArray) {
        if (stringArray.length == 1) {
            throw new IllegalArgumentException("legal options must include at least two entries");
        }
        this.options = stringArray;
        this.optionDesc.setSize(stringArray.length);
    }

    public String[] getOptions() {
        return this.options;
    }

    public boolean hasLegalOptions() {
        return this.options != null && this.options.length > 1;
    }

    public void setOptionDescription(int n, String string) {
        this.optionDesc.setElementAt(string, n);
    }

    public String getOptionDescription(int n) {
        String string = (String)this.optionDesc.elementAt(n);
        return string != null ? string : "";
    }

    public void setPromptForOptionIndex(boolean bl) {
        this.promptForOptionIndex = bl;
    }

    public boolean getPromptForOptionIndex() {
        return this.promptForOptionIndex;
    }

    public void setMinLegalValue(int n) {
        this.min = n;
    }

    public int getMinLegalValue() {
        return this.min;
    }

    public boolean hasMinLegalValue() {
        return this.min > Integer.MIN_VALUE;
    }

    public void setMaxLegalValue(int n) {
        this.max = n;
    }

    public int getMaxLegalValue() {
        return this.max;
    }

    public boolean hasMaxLegalValue() {
        return this.max < Integer.MAX_VALUE;
    }

    public boolean hasMinMaxValues() {
        return this.hasMinLegalValue() && this.hasMaxLegalValue() && this.min <= this.max;
    }

    public void resetMinMaxValues() {
        this.min = Integer.MIN_VALUE;
        this.max = Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }
}

