/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.CoreURLUtils;
import com.installshield.boot.streamhandler.ArchiveURLStreamHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class BootResourceCache {
    public static final String REL_ENGINE_PATH = "engine";
    public static final String ENGINE_JAR_NAME = "engine.jar";
    public static final String REL_LIBRARY_PATH = "library";
    public static final String REL_EXTENSION_PATH = "ext";
    public static final String REL_DATA_PATH = "data";
    public static final String INSTALL_DATA_FILE = "assembly.dat";
    public static final String RESOURCE_MAP_FILE = "resource.map";
    public static final String MEDIA_MAP_FILE = "media.map";
    private String relResPath;
    private String relEngineResPath;
    private String relEngineJarResPath;
    private String relLibResPath;
    private String relExtResPath;
    private String relInstallDataResPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResourceFromArchive(String string, String string2, String string3) throws IOException {
        File file = new File(CoreFileUtils.getParent(string3));
        if (!file.exists()) {
            CoreFileUtils.createDirs(file);
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            URL uRL = BootResourceCache.createURL(string, string2);
            inputStream = uRL.openStream();
            fileOutputStream = new FileOutputStream(string3);
            CoreFileUtils.copy(inputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            CoreFileUtils.close(inputStream);
            CoreFileUtils.close(fileOutputStream);
            throw throwable;
        }
        CoreFileUtils.close(inputStream);
        CoreFileUtils.close(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean resourceExistsInArchive(String string, String string2) throws MalformedURLException {
        boolean bl = false;
        InputStream inputStream = null;
        try {
            URL uRL = BootResourceCache.createURL(string, string2);
            inputStream = uRL.openStream();
            bl = true;
            CoreFileUtils.close(inputStream);
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
            catch (IOException iOException) {
                return bl;
            }
        }
        finally {
            CoreFileUtils.close(inputStream);
        }
    }

    public static boolean deleteAccessedArchive(String string) {
        boolean bl = false;
        try {
            ArchiveURLStreamHandler.closeArchive(string);
            bl = new File(string).delete();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static URL createURL(String string, String string2) throws MalformedURLException {
        return new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(string + "+/" + string2));
    }

    public BootResourceCache(String string) {
        this.relResPath = string;
        this.relEngineResPath = string + "/" + REL_ENGINE_PATH;
        this.relEngineJarResPath = this.relEngineResPath + "/" + ENGINE_JAR_NAME;
        this.relLibResPath = this.relEngineResPath + "/" + REL_LIBRARY_PATH;
        this.relExtResPath = this.relEngineResPath + "/" + REL_EXTENSION_PATH;
        this.relInstallDataResPath = string + "/" + REL_DATA_PATH;
    }

    public String getRelResourcePath() {
        return this.relResPath;
    }

    public String getRelEngineResPath() {
        return this.relEngineResPath;
    }

    public String getRelEngineJarPath() {
        return this.relEngineJarResPath;
    }

    public String getRelLibraryPath() {
        return this.relLibResPath;
    }

    public String getRelLibraryJarPath(String string) {
        return this.relLibResPath + "/" + string;
    }

    public String getRelEngineExtensionPath() {
        return this.relExtResPath;
    }

    public String getRelEngineExtensionJarPath(String string) {
        return this.relExtResPath + "/" + string;
    }

    public String getRelInstallDataPath() {
        return this.relInstallDataResPath;
    }

    public String getRelInstallDataPath(String string, String string2) {
        return this.relInstallDataResPath + "/" + string + "/" + string2;
    }

    public String getRelInstallDataFilePath(String string, String string2) {
        return this.relInstallDataResPath + "/" + string + "/" + string2 + "/" + INSTALL_DATA_FILE;
    }

    public String getRelResourceMapFilePath(String string, String string2) {
        return this.relInstallDataResPath + "/" + string + "/" + string2 + "/" + RESOURCE_MAP_FILE;
    }

    public String getRelMediaMapFilePath(String string, String string2) {
        return this.relInstallDataResPath + "/" + string + "/" + string2 + "/" + MEDIA_MAP_FILE;
    }
}

