/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.AssemblyInf;
import com.installshield.boot.AssemblyMediaInfo;
import com.installshield.boot.BootException;
import com.installshield.boot.BootInf;
import com.installshield.boot.BootResourceCache;
import com.installshield.boot.Bootstrap;
import com.installshield.boot.BootstrapInfo;
import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.CoreLocalizedStringResolver;
import com.installshield.boot.CoreURLUtils;
import com.installshield.boot.EngineUtils;
import com.installshield.boot.ISMPClassLoader;
import com.installshield.boot.SetupCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class BootMain {
    private static final String DEBUG_TAG = "is.debug";
    private static final String FORCE_CL_CMD_TAG = "-enginehome";
    private static final String FORCE_DATA_CMD_TAG = "-datahome";
    private static final String INSTALL_ONLY_TAG = "-installengine";
    private static final String FORCE_ENGINE_INSTALL_TAG = "-force";
    private static final String ADD_SEARCH_PATH_TAG = "-searchpath";
    private static final String LOCALE_TAG = "-locale";
    private static final String SILENT_MODE_TAG = "-silent";
    private static final String CONSOLE_MODE_TAG = "-console";
    private static final String SWING_MODE_TAG = "-swing";
    protected static final int SILENT_MODE = 0;
    protected static final int CONSOLE_MODE = 1;
    protected static final int SWING_MODE = 2;
    private String[] cmdLineArgs = new String[0];
    private String home = null;
    private String mediaHome = null;
    private String archive = null;
    private URL runInfURL = null;
    private BootInf bootInf = null;
    private String externalHome = null;
    private boolean canInstallEngine = false;
    private boolean installEngineOnly = false;
    private boolean forceEngineInstall = false;
    private List externalClassJars = new ArrayList();
    private int uiMode = 2;
    private ISMPClassLoader classLoader = null;
    private BootResourceCache bootResCache = null;

    private static void exitWithError(int n, String string) {
        System.err.println(string);
        System.exit(n);
    }

    private static void exitWithError(int n, String string, Exception exception) {
        System.err.println(string);
        if (System.getProperty(DEBUG_TAG) != null) {
            exception.printStackTrace();
        }
        System.exit(n);
    }

    private static void processSearchPath(String string, SetupCache setupCache, List list) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = CoreFileUtils.normalizeFileName(stringTokenizer.nextToken());
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                String[] stringArray = SetupCache.availableInstallDataFiles(string2);
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    list.add(stringArray[i]);
                    try {
                        AssemblyInf assemblyInf = AssemblyInf.createAssemblyInf(stringArray[i]);
                        String string3 = CoreFileUtils.getParent(stringArray[i]);
                        String string4 = CoreFileUtils.createFileName(string3, "media.map");
                        AssemblyMediaInfo assemblyMediaInfo = null;
                        assemblyMediaInfo = new File(string4).exists() && new File(string4).isFile() ? new AssemblyMediaInfo(string3, null, stringArray[i]) : new AssemblyMediaInfo(stringArray[i], null, stringArray[i]);
                        SetupCache.getSetupCache().addAssemblyMediaInfo(assemblyInf.getAssemblyUUID(), assemblyInf.getAssemblyVersion(), assemblyMediaInfo);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("invalid search path: " + string2);
                    }
                }
                setupCache.addInstallDataSearchPath(string2);
                continue;
            }
            System.out.println("invalid search path: " + string2);
        }
    }

    private static boolean unpackInstallData(String string, String string2, String string3, List list) {
        boolean bl;
        block8: {
            bl = true;
            try {
                String string4 = CoreFileUtils.appendSeparator(string3) + "assembly.dat";
                String string5 = CoreFileUtils.appendSeparator(string3) + "resource.map";
                File file = new File(string4);
                File file2 = new File(string5);
                if (file.exists() && !file.delete()) {
                    throw new IOException("could not delete install data file: " + string4);
                }
                if (file2.exists() && !file2.delete()) {
                    throw new IOException("could not delete resource map file: " + string5);
                }
                String string6 = CoreFileUtils.appendSeparator(string2) + "assembly.dat";
                String string7 = CoreFileUtils.appendSeparator(string2) + "resource.map";
                try {
                    BootResourceCache.extractResourceFromArchive(string, string6, string4);
                    list.add(string4);
                }
                catch (IOException iOException) {
                    throw new IOException("could not locate install data file: " + string6);
                }
                try {
                    BootResourceCache.extractResourceFromArchive(string, string7, string5);
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                bl = false;
                if (System.getProperty(DEBUG_TAG) == null) break block8;
                System.err.println("could not unpack assembly (" + string2 + ") to target (" + string3 + ")");
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private void configureMediaLocation(String string, String string2, String string3, String string4, String string5) {
        String string6 = CoreFileUtils.appendSeparator(string5) + "assembly.dat";
        try {
            String string7 = CoreFileUtils.appendSeparator(string4) + "media.map";
            AssemblyMediaInfo assemblyMediaInfo = null;
            if (BootResourceCache.resourceExistsInArchive(string, string7)) {
                assemblyMediaInfo = new AssemblyMediaInfo(string, string4, string6);
            } else if (!this.bootInf.isSpanned()) {
                assemblyMediaInfo = new AssemblyMediaInfo(string6, null, string6);
            }
            SetupCache.getSetupCache().addAssemblyMediaInfo(string2, string3, assemblyMediaInfo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static String[] stripArguments(String[] stringArray, int n, int n2) {
        String[] stringArray2 = stringArray;
        if (stringArray != null && stringArray.length > 0 && n2 > 0 && n >= 0) {
            if (n == 0 && n2 == stringArray.length) {
                stringArray2 = new String[]{};
            } else if (n + n2 <= stringArray.length) {
                stringArray2 = new String[stringArray.length - n2];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                if (n + n2 < stringArray.length) {
                    System.arraycopy(stringArray, n + n2, stringArray2, n, stringArray.length - (n + n2));
                }
            }
        }
        return stringArray2;
    }

    protected String[] getCommandLineArguments() {
        return this.cmdLineArgs;
    }

    protected String getHome() {
        return this.home;
    }

    protected String getMediaHome() {
        return this.mediaHome;
    }

    protected String getArchive() {
        return this.archive;
    }

    protected URL getRunInfURL() {
        return this.runInfURL;
    }

    protected BootInf getBootInf() {
        return this.bootInf;
    }

    protected String getExternalHome() {
        return this.externalHome;
    }

    protected boolean getCanInstallEngine() {
        return this.canInstallEngine;
    }

    protected boolean isInstallEngineOnly() {
        return this.installEngineOnly;
    }

    protected boolean isForceEngineInstall() {
        return this.forceEngineInstall;
    }

    protected List getExternalClassJars() {
        return this.externalClassJars;
    }

    protected int getUIMode() {
        return this.uiMode;
    }

    protected ISMPClassLoader getISMPClassLoader() throws BootException {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        throw new BootException("ismp class loader unavailable: class loader not yet initialized");
    }

    protected BootResourceCache getBootResourceCache() {
        return this.bootResCache;
    }

    public void boot(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        Object object5;
        String string2;
        block95: {
            Object object6;
            Object object7;
            int n;
            String string3;
            int n2;
            String string4;
            String string5;
            Object object8;
            int n3;
            if (EngineUtils.getJavaVersion() < 1.4f) {
                BootMain.exitWithError(-1, CoreLocalizedStringResolver.resolve("com.installshield.boot.i18n.BootResources", "BootUI.badJVMVersion", new String[]{String.valueOf(1.4f)}));
            }
            this.cmdLineArgs = stringArray;
            this.home = null;
            this.mediaHome = null;
            this.archive = null;
            this.runInfURL = null;
            this.bootInf = null;
            String string6 = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string6, File.pathSeparator);
            boolean bl = false;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (!stringArray[n3].equals(LOCALE_TAG)) continue;
                bl = true;
                if (stringArray.length > n3 + 1) {
                    try {
                        object8 = this.getLocale(stringArray[n3 + 1]);
                        Locale.setDefault((Locale)object8);
                        stringArray = BootMain.stripArguments(stringArray, n3, 2);
                    }
                    catch (Exception exception) {
                        BootMain.exitWithError(-1, "could not override locale with locale string provided");
                    }
                    continue;
                }
                BootMain.exitWithError(-1, "locale override not specified");
            }
            while (stringTokenizer.hasMoreTokens() && this.runInfURL == null) {
                String string7 = stringTokenizer.nextToken();
                try {
                    string7 = new File(string7).getCanonicalPath();
                    this.runInfURL = new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(string7 + "+/" + "run.inf"));
                    object8 = this.runInfURL.openStream();
                    ((InputStream)object8).close();
                    this.home = new File(string7).getAbsolutePath();
                    string5 = CoreFileUtils.getParent(this.home);
                    string4 = null;
                    string4 = new File(this.home).isFile() ? CoreFileUtils.getParent(this.home) : this.home;
                    string2 = CoreFileUtils.createFileName(string4, "run.inf");
                    object5 = new File(string2);
                    if (((File)object5).exists() && ((File)object5).isFile()) {
                        this.runInfURL = new URL("archive", "", -1, CoreURLUtils.encodeArchiveURLPath(string4 + "+/" + "run.inf"));
                        if (!new File(this.home).isFile()) {
                            string5 = this.home;
                        }
                    }
                    this.bootInf = this.loadBootInf(this.runInfURL);
                    this.mediaHome = string5;
                    this.archive = this.home;
                }
                catch (Exception exception) {
                    if (System.getProperty(DEBUG_TAG) != null) {
                        exception.printStackTrace();
                    }
                    this.runInfURL = null;
                    this.bootInf = null;
                    this.home = null;
                    this.mediaHome = null;
                    this.archive = null;
                }
            }
            if (this.bootInf == null) {
                BootMain.exitWithError(-1, "cannot find \"run.inf\"");
            }
            this.externalHome = System.getProperty("is.external.home");
            if (this.externalHome == null) {
                this.externalHome = this.mediaHome;
                System.setProperty("is.external.home", this.externalHome);
            }
            if (System.getProperty(DEBUG_TAG) != null) {
                System.out.println("*** START BOOTINF (" + this.runInfURL.toExternalForm() + ") ***");
                System.out.println(this.bootInf.toString());
                System.out.println("*** END BOOTINF ***");
            }
            this.uiMode = 2;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3].equals(CONSOLE_MODE_TAG)) {
                    this.uiMode = 1;
                    break;
                }
                if (stringArray[n3].equals(SILENT_MODE_TAG)) {
                    this.uiMode = 0;
                    break;
                }
                if (stringArray[n3].equals(SWING_MODE_TAG)) break;
            }
            if ((string = this.bootInf.getStartClass()) == null || string.length() == 0) {
                BootMain.exitWithError(-1, "start class not specified in \"run.inf\"");
            }
            if ((object8 = this.bootInf.getEngineVersion()) == null || ((String)object8).length() == 0) {
                BootMain.exitWithError(-1, "engine version not specified in \"run.inf\"");
            }
            this.canInstallEngine = false;
            string5 = null;
            string4 = this.bootInf.getInstallResourcePath();
            if (string4 != null && string4.trim().length() != 0) {
                this.bootResCache = this.createBootResourceCache(string4);
                this.canInstallEngine = true;
                string5 = this.bootResCache.getRelEngineJarPath();
            }
            if ((string2 = this.bootInf.getRootUUID()) == null || string2.trim().length() == 0) {
                BootMain.exitWithError(-1, "no UUID given for root product");
            }
            if ((object5 = this.bootInf.getRootVersion()) == null || ((String)object5).trim().length() == 0) {
                BootMain.exitWithError(-1, "no version given for root product: " + string2);
            }
            int n4 = this.bootInf.getInstallDataCount();
            boolean bl2 = false;
            String string8 = null;
            String string9 = this.bootInf.getRootDataLocation();
            if (string9 != null && string9.trim().length() > 0) {
                string8 = CoreFileUtils.canonizePath(CoreFileUtils.createFileName(this.mediaHome, string9));
            }
            for (n2 = 0; n2 < n4 && !bl2; ++n2) {
                String string10;
                String string11 = this.bootInf.getInstallDataUUID(n2);
                if (string11 == null || string11.trim().length() == 0) {
                    BootMain.exitWithError(-1, "no UUID given for install data[" + n2 + "]");
                }
                if ((string10 = this.bootInf.getInstallDataVersion(n2)) == null || string10.trim().length() == 0) {
                    BootMain.exitWithError(-1, "no version given for install data[" + n2 + "]: " + string11);
                }
                if (!string11.equals(string2) || !string10.equals(object5)) continue;
                bl2 = true;
            }
            if (!(bl2 || string8 != null && string8.trim().length() != 0)) {
                BootMain.exitWithError(-1, "root product data not found in archive: " + string2 + "[" + (String)object5 + "]");
            }
            this.installEngineOnly = false;
            for (n2 = 0; !this.installEngineOnly && n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].equals(INSTALL_ONLY_TAG)) continue;
                this.installEngineOnly = true;
                stringArray = BootMain.stripArguments(stringArray, n2, 1);
            }
            this.forceEngineInstall = false;
            for (n2 = 0; !this.forceEngineInstall && n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].equals(FORCE_ENGINE_INSTALL_TAG)) continue;
                this.forceEngineInstall = true;
                stringArray = BootMain.stripArguments(stringArray, n2, 1);
            }
            if (this.forceEngineInstall && !this.canInstallEngine) {
                BootMain.exitWithError(-1, "forced engine install can only be run from source media");
            }
            String string12 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(FORCE_CL_CMD_TAG)) continue;
                if (stringArray.length > i + 1) {
                    string12 = CoreFileUtils.normalizeFileName(stringArray[i + 1]);
                    stringArray = BootMain.stripArguments(stringArray, i, 2);
                    continue;
                }
                BootMain.exitWithError(-1, "path for engine home not specified");
            }
            if ((string12 == null || string12.trim().length() == 0) && (string3 = this.bootInf.getEngineLocation()) != null && string3.trim().length() > 0) {
                string12 = CoreFileUtils.canonizePath(CoreFileUtils.createFileName(this.mediaHome, string3));
            }
            if (string12 == null || string12.trim().length() == 0) {
                try {
                    string12 = CoreFileUtils.normalizeFileName(CoreFileUtils.createTempDir());
                }
                catch (Exception exception) {
                    if (System.getProperty(DEBUG_TAG) != null) {
                        exception.printStackTrace();
                    }
                    string12 = null;
                }
            }
            if (string12 == null || string12.trim().length() == 0) {
                BootMain.exitWithError(-1, "could not determine central location: use \"-enginehome\" to set manually");
            }
            String string13 = null;
            for (int i = 0; (string13 == null || string13.trim().length() == 0) && i < stringArray.length; ++i) {
                if (!stringArray[i].equals(FORCE_DATA_CMD_TAG)) continue;
                if (stringArray.length > i + 1) {
                    string13 = CoreFileUtils.normalizeFileName(stringArray[i + 1]);
                    stringArray = BootMain.stripArguments(stringArray, i, 2);
                    continue;
                }
                BootMain.exitWithError(-1, "path for install data home not specified");
            }
            if (string13 == null || string13.trim().length() == 0) {
                try {
                    string13 = CoreFileUtils.normalizeFileName(CoreFileUtils.createTempDir());
                }
                catch (Exception exception) {
                    if (System.getProperty(DEBUG_TAG) != null) {
                        exception.printStackTrace();
                    }
                    string13 = null;
                }
            }
            if (string13 == null || string13.trim().length() == 0) {
                BootMain.exitWithError(-1, "could not determine install data location: use \"-datahome\" to set manually");
            }
            this.initializeSetupCache(this.mediaHome, this.archive, this.externalHome, (String)object8, string12, string13);
            try {
                this.preCoreInitialize();
            }
            catch (BootException bootException) {
                BootMain.exitWithError(-1, bootException.getMessage(), bootException);
            }
            SetupCache setupCache = SetupCache.getSetupCache();
            String string14 = setupCache.getEngineJar();
            if (!new File(string12).exists()) {
                if (this.canInstallEngine) {
                    try {
                        CoreFileUtils.createDirs(new File(string12));
                    }
                    catch (Exception exception) {
                        BootMain.exitWithError(-1, "could not create engine location: " + string12, exception);
                    }
                } else {
                    BootMain.exitWithError(-1, "engine is missing (" + string12 + "): run installation from source media");
                }
            }
            this.externalClassJars = new ArrayList();
            if (this.canInstallEngine) {
                try {
                    EngineUtils.installEngine(this.home, (String)object8, string5, this.forceEngineInstall, string14);
                }
                catch (Exception exception) {
                    BootMain.exitWithError(-1, "could not install engine jar", exception);
                }
            } else if (!new File(string14).exists()) {
                BootMain.exitWithError(-1, "run installation from source media: engine is missing: " + string14);
            }
            this.externalClassJars.add(string14);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n = 0; n < this.bootInf.getLibraryJarCount(); ++n) {
                object4 = this.bootInf.getRelativeLibraryJar(n);
                object7 = setupCache.getLibraryJar((String)object4);
                if (this.canInstallEngine) {
                    object6 = this.bootResCache.getRelLibraryJarPath((String)object4);
                    try {
                        EngineUtils.installEngineLibrary(this.home, (String)object6, (String)object7);
                        arrayList.add(object7);
                        this.externalClassJars.add(object7);
                    }
                    catch (IOException iOException) {
                        if (System.getProperty(DEBUG_TAG) != null) {
                            System.err.println("could not install engine extension (" + (String)object6 + ")");
                            iOException.printStackTrace();
                            continue;
                        }
                        System.err.println("could not install engine extension (" + (String)object6 + "): run with \"" + DEBUG_TAG + "\" for more information");
                    }
                    continue;
                }
                if (new File((String)object7).exists()) {
                    arrayList.add(object7);
                    this.externalClassJars.add(object7);
                    continue;
                }
                if (System.getProperty(DEBUG_TAG) == null) continue;
                System.err.println("invalid installed engine extension: " + (String)object7);
            }
            for (n = 0; n < this.bootInf.getExtensionJarCount(); ++n) {
                object4 = this.bootInf.getRelativeExtensionJar(n);
                object7 = setupCache.getEngineExtensionJar((String)object4);
                if (this.canInstallEngine) {
                    object6 = this.bootResCache.getRelEngineExtensionJarPath((String)object4);
                    try {
                        EngineUtils.installEngineExtension((String)object8, this.home, (String)object6, (String)object7);
                        arrayList.add(object7);
                        this.externalClassJars.add(object7);
                    }
                    catch (IOException iOException) {
                        if (System.getProperty(DEBUG_TAG) != null) {
                            System.err.println("could not install engine extension (" + (String)object6 + ")");
                            iOException.printStackTrace();
                            continue;
                        }
                        System.err.println("could not install engine extension (" + (String)object6 + "): run with \"" + DEBUG_TAG + "\" for more information");
                    }
                    continue;
                }
                if (new File((String)object7).exists()) {
                    arrayList.add(object7);
                    this.externalClassJars.add(object7);
                    continue;
                }
                if (System.getProperty(DEBUG_TAG) == null) continue;
                System.err.println("invalid installed engine extension: " + (String)object7);
            }
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            if (!this.installEngineOnly) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(ADD_SEARCH_PATH_TAG)) continue;
                    if (stringArray.length > i + 1) {
                        object7 = stringArray[i + 1];
                        stringArray = BootMain.stripArguments(stringArray, i, 2);
                        BootMain.processSearchPath((String)object7, setupCache, this.externalClassJars);
                        continue;
                    }
                    BootMain.exitWithError(-1, "search path not specified");
                }
                object4 = setupCache.getDefaultInstallDataSearchPath();
                object7 = new File((String)object4);
                if (((File)object7).exists() && ((File)object7).isDirectory()) {
                    BootMain.processSearchPath((String)object4, setupCache, this.externalClassJars);
                }
                if (this.canInstallEngine) {
                    for (int i = 0; i < n4; ++i) {
                        object3 = this.bootInf.getInstallDataUUID(i);
                        if (setupCache.isInstallDataAvailable((String)object3, (String)(object2 = this.bootInf.getInstallDataVersion(i)))) continue;
                        object = CoreFileUtils.normalizeFileName(setupCache.getInstallDataHome((String)object3, (String)object2));
                        String string15 = this.bootResCache.getRelInstallDataPath((String)object3, (String)object2);
                        boolean bl3 = BootMain.unpackInstallData(this.home, string15, (String)object, this.externalClassJars);
                        if (!bl3) {
                            BootMain.exitWithError(-1, "could not unpack install data (" + (String)object3 + "[" + (String)object2 + "]): run with \"" + DEBUG_TAG + "\" for more information");
                        }
                        this.configureMediaLocation(this.home, (String)object3, (String)object2, string15, (String)object);
                    }
                } else {
                    if (string8 == null) {
                        BootMain.exitWithError(-1, "root location data not set");
                    }
                    if (!((File)(object6 = new File(string8))).exists()) {
                        BootMain.exitWithError(-1, "could not locate root data location (" + string8 + ")");
                    }
                    setupCache.addInstallDataHome(string2, (String)object5, string8);
                    this.externalClassJars.add(setupCache.getInstallDataFileName(string2, (String)object5));
                }
            }
            if (!this.bootInf.isSpanned()) {
                System.setProperty("is.media.home", setupCache.getInstallDataFileName(string2, (String)object5));
            }
            object4 = null;
            try {
                object4 = ISMPClassLoader.createLibraryURL(setupCache.getClassHomePath());
            }
            catch (IOException iOException) {
                if (System.getProperty(DEBUG_TAG) == null) break block95;
                iOException.printStackTrace();
            }
        }
        this.classLoader = object4 != null ? new ISMPClassLoader(new URL[]{object4}, BootMain.class.getClassLoader()) : new ISMPClassLoader(new URL[]{}, BootMain.class.getClassLoader());
        int n = this.bootInf.getAdditionalClassPathCount();
        for (int i = 0; i < n; ++i) {
            object3 = this.bootInf.getAdditionalClassPath(i);
            if (object3 == null || ((String)object3).trim().length() <= 0) continue;
            object2 = new File((String)object3);
            if (((File)object2).exists()) {
                try {
                    this.classLoader.appendLibs(new String[]{object3});
                }
                catch (IOException iOException) {
                    System.out.println("Additional class path caused exception: " + (String)object3);
                }
                continue;
            }
            System.out.println("Additional class path file not found: " + (String)object3);
        }
        try {
            this.postCoreInitialize();
        }
        catch (BootException bootException) {
            BootMain.exitWithError(-1, bootException.getMessage(), bootException);
        }
        if (!this.installEngineOnly) {
            try {
                String[] stringArray3 = new String[this.externalClassJars.size()];
                this.externalClassJars.toArray(stringArray3);
                if (System.getProperty(DEBUG_TAG) != null) {
                    object3 = new StringBuffer();
                    ((StringBuffer)object3).append("EXTERNAL CLASS JAR LIST: ");
                    for (int i = 0; i < stringArray3.length; ++i) {
                        ((StringBuffer)object3).append(stringArray3[i]);
                        if (i == stringArray3.length - 1) continue;
                        ((StringBuffer)object3).append(", ");
                    }
                    System.out.println(((StringBuffer)object3).toString());
                }
                this.classLoader.appendLibs(stringArray3);
                object3 = this.classLoader.loadClass(string);
                Object t = ((Class)object3).newInstance();
                if (t instanceof Bootstrap) {
                    object = this.createBootstrapInfo(this.bootInf, stringArray, string2, (String)object5);
                    ((Bootstrap)t).startup((BootstrapInfo)object);
                } else {
                    BootMain.exitWithError(-1, "start class (" + string + ") not instance of Bootstrap");
                }
            }
            catch (Exception exception) {
                BootMain.exitWithError(-1, "could not utilize start class: " + string, exception);
            }
        }
    }

    protected BootInf loadBootInf(URL uRL) throws IOException {
        return new BootInf(uRL);
    }

    protected BootResourceCache createBootResourceCache(String string) {
        return new BootResourceCache(string);
    }

    protected void initializeSetupCache(String string, String string2, String string3, String string4, String string5, String string6) {
        SetupCache.createSetupCache(string5, string6, string4, string, string2, string3);
    }

    protected void preCoreInitialize() throws BootException {
    }

    protected void postCoreInitialize() throws BootException {
    }

    protected BootstrapInfo createBootstrapInfo(BootInf bootInf, String[] stringArray, String string, String string2) {
        return new BootstrapInfo(bootInf, string, string2, stringArray);
    }

    private Locale getLocale(String string) throws IllegalArgumentException {
        Locale locale = null;
        if (string == null || string.length() < 5) {
            throw new IllegalArgumentException("locale string is either null or < 5");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (!stringTokenizer.hasMoreElements()) {
            throw new IllegalArgumentException("Must provide Language and Country code");
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 2) {
            throw new IllegalArgumentException("Language code provided is not supported");
        }
        if (!stringTokenizer.hasMoreElements()) {
            throw new IllegalArgumentException("Must provide Language and Country code");
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.length() != 2) {
            throw new IllegalArgumentException("Country code provided is not supported");
        }
        if (!stringTokenizer.hasMoreElements()) {
            locale = new Locale(string2, string3);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append('_');
                stringBuffer.append(stringTokenizer.nextToken());
            }
            locale = new Locale(string2, string3, stringBuffer.toString());
        }
        return locale;
    }
}

