/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreMetaInf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;

public class BootInf
extends CoreMetaInf {
    public static final String RESOURCE_NAME = "run.inf";
    private static final String START_CLASS = "START_CLASS";
    private static final String INSTALL_RES_PATH = "INST_RES";
    private static final String ENGINE_LOCATION = "ENG_LOC";
    static final String ENGINE_VERSION = "ENG_VER";
    static final String ENGINE_UPDATE_VERSION = "ENG_UPDATE_VER";
    private static final String LIBRARY_JAR_COUNT = "LIB_JAR_COUNT";
    private static final String LIBRARY_JAR_TAG = "LIB_JAR";
    private static final String EXTENSION_JAR_COUNT = "EXT_JAR_COUNT";
    private static final String EXTENSION_JAR_TAG = "EXT_JAR";
    private static final String ADDITIONAL_CLASSPATH_COUNT = "CP_COUNT";
    private static final String ADDITIONAL_CLASSPATH_TAG = "CP";
    private static final String ROOT_UUID = "ROOT_UUID";
    private static final String ROOT_VERSION = "ROOT_VER";
    private static final String ROOT_DATA_LOCATION = "ROOT_DATA_LOC";
    private static final String DATA_COUNT = "DATA_COUNT";
    private static final String DATA_TAG = "DATA";
    private static final String DATA_INFO_SEPARATOR = ";";
    private static final int DATA_INFO_SEPARATOR_LENGTH = ";".length();
    private static final String IS_SPANNED = "SPAN";
    private static final String PROMPT_FOR_PHASE_RESOLUTION = "PHASE_PROMPT";
    private static final String DEFAULT_START_CLASS = "com.installshield.wizard.Wizard";
    private static final String DEFAULT_INSTALL_RES_PATH = "";
    private static final String DEFAULT_ENGINE_LOCATION = "";
    private static final String DEFAULT_ENGINE_VERSION = "6.0";
    private static final String DEFAULT_ENGINE_UPDATE_VERSION = "0";
    private static final String DEFAULT_ROOT_UUID = "";
    private static final String DEFAULT_ROOT_VERSION = "";
    private static final String DEFAULT_ROOT_DATA_LOCATION = "";
    private static final boolean DEFAULT_SPANNED = false;
    private static final boolean DEFAULT_PHASE_PROMPT = false;
    private String startClass;
    private String installResPath;
    private String engineLocation;
    private String engineVer;
    private String engineUpdateVer;
    private List relLibJarPaths;
    private List relExtJarPaths;
    private List additionalClassPaths;
    private List dataItems;
    private String rootUUID;
    private String rootVersion;
    private String rootDataLocation;
    private boolean isSpanned;
    private boolean promptForPhaseResolution;

    public BootInf() {
        this.initializeDefaults();
    }

    public BootInf(URL uRL) throws IOException {
        super(uRL);
    }

    public BootInf(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    protected void initializeDefaults() {
        this.startClass = DEFAULT_START_CLASS;
        this.installResPath = "";
        this.engineLocation = "";
        this.engineVer = DEFAULT_ENGINE_VERSION;
        this.engineUpdateVer = DEFAULT_ENGINE_UPDATE_VERSION;
        this.relLibJarPaths = new ArrayList();
        this.relExtJarPaths = new ArrayList();
        this.additionalClassPaths = new ArrayList();
        this.dataItems = new ArrayList();
        this.rootUUID = "";
        this.rootVersion = "";
        this.rootDataLocation = "";
        this.isSpanned = false;
        this.promptForPhaseResolution = false;
    }

    public void read(Dictionary dictionary) {
        this.initializeDefaults();
        if (dictionary.get(START_CLASS) != null) {
            this.startClass = (String)dictionary.get(START_CLASS);
        }
        if (dictionary.get(INSTALL_RES_PATH) != null) {
            this.installResPath = (String)dictionary.get(INSTALL_RES_PATH);
        }
        if (dictionary.get(ENGINE_LOCATION) != null) {
            this.engineLocation = (String)dictionary.get(ENGINE_LOCATION);
        }
        if (dictionary.get(ENGINE_VERSION) != null) {
            this.engineVer = (String)dictionary.get(ENGINE_VERSION);
        }
        if (dictionary.get(ENGINE_UPDATE_VERSION) != null) {
            this.engineUpdateVer = (String)dictionary.get(ENGINE_UPDATE_VERSION);
        }
        this.relLibJarPaths = this.read(dictionary, LIBRARY_JAR_COUNT, LIBRARY_JAR_TAG);
        this.relExtJarPaths = this.read(dictionary, EXTENSION_JAR_COUNT, EXTENSION_JAR_TAG);
        this.additionalClassPaths = this.read(dictionary, ADDITIONAL_CLASSPATH_COUNT, ADDITIONAL_CLASSPATH_TAG);
        this.dataItems = this.read(dictionary, DATA_COUNT, DATA_TAG);
        if (dictionary.get(ROOT_UUID) != null) {
            this.rootUUID = (String)dictionary.get(ROOT_UUID);
        }
        if (dictionary.get(ROOT_VERSION) != null) {
            this.rootVersion = (String)dictionary.get(ROOT_VERSION);
        }
        if (dictionary.get(ROOT_DATA_LOCATION) != null) {
            this.rootDataLocation = (String)dictionary.get(ROOT_DATA_LOCATION);
        }
        if (dictionary.get(IS_SPANNED) != null) {
            this.isSpanned = Boolean.valueOf((String)dictionary.get(IS_SPANNED));
        }
        if (dictionary.get(PROMPT_FOR_PHASE_RESOLUTION) != null) {
            this.promptForPhaseResolution = Boolean.valueOf((String)dictionary.get(PROMPT_FOR_PHASE_RESOLUTION));
        }
        this.readInternal(dictionary);
    }

    private List read(Dictionary dictionary, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object v = dictionary.get(string);
        if (v != null) {
            int n = Integer.parseInt((String)v);
            for (int i = 0; i < n; ++i) {
                String string3 = (String)dictionary.get(string2 + "." + i);
                if (string3 == null || string3.trim().length() == 0) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    protected void readInternal(Dictionary dictionary) {
    }

    public String getFileName() {
        return RESOURCE_NAME;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3;
        Properties properties = new Properties();
        properties.put(START_CLASS, this.startClass);
        properties.put(INSTALL_RES_PATH, this.installResPath);
        properties.put(ENGINE_LOCATION, this.engineLocation);
        properties.put(ENGINE_VERSION, this.engineVer);
        properties.put(ENGINE_UPDATE_VERSION, this.engineUpdateVer);
        int n4 = this.getLibraryJarCount();
        properties.put(LIBRARY_JAR_COUNT, String.valueOf(n4));
        for (n3 = 0; n3 < n4; ++n3) {
            properties.put("LIB_JAR." + n3, this.getRelativeLibraryJar(n3));
        }
        n3 = this.getExtensionJarCount();
        properties.put(EXTENSION_JAR_COUNT, String.valueOf(n3));
        for (n2 = 0; n2 < n3; ++n2) {
            properties.put("EXT_JAR." + n2, this.getRelativeExtensionJar(n2));
        }
        n2 = this.getAdditionalClassPathCount();
        properties.put(ADDITIONAL_CLASSPATH_COUNT, String.valueOf(n2));
        for (n = 0; n < n2; ++n) {
            properties.put("CP." + n, this.getAdditionalClassPath(n));
        }
        n = this.getInstallDataCount();
        properties.put(DATA_COUNT, String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            properties.put("DATA." + i, this.getInstallDataItem(i));
        }
        properties.put(ROOT_UUID, this.rootUUID);
        properties.put(ROOT_VERSION, this.rootVersion);
        properties.put(ROOT_DATA_LOCATION, this.rootDataLocation);
        properties.put(IS_SPANNED, String.valueOf(this.isSpanned));
        properties.put(PROMPT_FOR_PHASE_RESOLUTION, String.valueOf(this.promptForPhaseResolution));
        this.writeInternal(properties);
        properties.store(outputStream, "Run Properties");
    }

    protected void writeInternal(Properties properties) throws IOException {
    }

    public void setStartClass(String string) {
        this.startClass = string;
    }

    public String getStartClass() {
        return this.startClass;
    }

    public void setInstallResourcePath(String string) {
        this.installResPath = string;
    }

    public String getInstallResourcePath() {
        return this.installResPath;
    }

    public void setEngineLocation(String string) {
        this.engineLocation = string;
    }

    public String getEngineLocation() {
        return this.engineLocation;
    }

    public void setEngineVersion(String string) {
        this.engineVer = string;
    }

    public String getEngineVersion() {
        return this.engineVer;
    }

    public void setEngineUpdateVersion(String string) {
        this.engineUpdateVer = string;
    }

    public String getEngineUpdateVersion() {
        return this.engineUpdateVer;
    }

    public void addLibraryJar(String string) {
        if (string != null && !this.relLibJarPaths.contains(string)) {
            this.relLibJarPaths.add(string);
        }
    }

    public int getLibraryJarCount() {
        return this.relLibJarPaths.size();
    }

    public String getRelativeLibraryJar(int n) {
        return (String)this.relLibJarPaths.get(n);
    }

    public void addExtensionJar(String string) {
        if (string != null && !this.relExtJarPaths.contains(string)) {
            this.relExtJarPaths.add(string);
        }
    }

    public int getExtensionJarCount() {
        return this.relExtJarPaths.size();
    }

    public String getRelativeExtensionJar(int n) {
        return (String)this.relExtJarPaths.get(n);
    }

    public void addAdditionalClassPath(String string) {
        if (string != null && !this.additionalClassPaths.contains(string)) {
            this.additionalClassPaths.add(string);
        }
    }

    public int getAdditionalClassPathCount() {
        return this.additionalClassPaths.size();
    }

    public String getAdditionalClassPath(int n) {
        return (String)this.additionalClassPaths.get(n);
    }

    public void addInstallData(String string, String string2) {
        if (string != null) {
            String string3 = string;
            if (string2 != null) {
                string3 = string3 + DATA_INFO_SEPARATOR + string2;
            }
            this.dataItems.add(string3);
        }
    }

    public int getInstallDataCount() {
        return this.dataItems.size();
    }

    public String getInstallDataUUID(int n) {
        String string = this.getInstallDataItem(n);
        int n2 = string.indexOf(DATA_INFO_SEPARATOR);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }

    public String getInstallDataVersion(int n) {
        String string = this.getInstallDataItem(n);
        int n2 = string.indexOf(DATA_INFO_SEPARATOR);
        if (n2 < 0) {
            return "";
        }
        return (n2 += DATA_INFO_SEPARATOR_LENGTH) < string.length() ? string.substring(n2) : "";
    }

    private String getInstallDataItem(int n) {
        return (String)this.dataItems.get(n);
    }

    public void setRootUUID(String string) {
        this.rootUUID = string;
    }

    public String getRootUUID() {
        return this.rootUUID;
    }

    public void setRootVersion(String string) {
        this.rootVersion = string;
    }

    public String getRootVersion() {
        return this.rootVersion;
    }

    public void setRootDataLocation(String string) {
        this.rootDataLocation = string;
    }

    public String getRootDataLocation() {
        return this.rootDataLocation;
    }

    public void setSpanned(boolean bl) {
        this.isSpanned = bl;
    }

    public boolean isSpanned() {
        return this.isSpanned;
    }

    public void setPromptForPhaseResolution(boolean bl) {
        this.promptForPhaseResolution = bl;
    }

    public boolean isPromptForPhaseResolution() {
        return this.promptForPhaseResolution;
    }

    public String toString() {
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("START_CLASS: " + this.startClass + "\n");
        stringBuffer.append("INST_RES: " + this.installResPath + "\n");
        stringBuffer.append("ENG_LOC: " + this.engineLocation + "\n");
        stringBuffer.append("ENG_VER: " + this.engineVer + "\n");
        int n4 = this.getLibraryJarCount();
        stringBuffer.append("LIB_JAR_COUNT: " + n4 + "\n");
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append("LIB_JAR." + n3 + ": " + this.getRelativeLibraryJar(n3) + "\n");
        }
        n3 = this.getExtensionJarCount();
        stringBuffer.append("EXT_JAR_COUNT: " + n3 + "\n");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append("EXT_JAR." + n2 + ": " + this.getRelativeExtensionJar(n2) + "\n");
        }
        n2 = this.getAdditionalClassPathCount();
        stringBuffer.append("CP_COUNT: " + n2 + "\n");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("CP." + n + ": " + this.getAdditionalClassPath(n) + "\n");
        }
        n = this.getInstallDataCount();
        stringBuffer.append("DATA_COUNT: " + n + "\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("DATA." + i + ": " + this.getInstallDataItem(i) + "\n");
        }
        stringBuffer.append("ROOT_UUID: " + this.rootUUID + "\n");
        stringBuffer.append("ROOT_VER: " + this.rootVersion + "\n");
        stringBuffer.append("ROOT_DATA_LOC: " + this.rootDataLocation + "\n");
        stringBuffer.append("SPAN: " + this.isSpanned + "\n");
        stringBuffer.append("PHASE_PROMPT: " + this.promptForPhaseResolution + "\n");
        this.addInternalString(stringBuffer);
        return stringBuffer.toString();
    }

    protected void addInternalString(StringBuffer stringBuffer) {
    }
}

